<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Models\Licensee;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use App\Http\Resources\LicenseeResource;

class LicenseeController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $licensee = Licensee::all();
        return response(['licensee' => LicenseeResource::collection($licensee), 'message'=> 'Retrieved successfully'], 200);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = $request->all();

        $validator = Validator::make($data,[
            'name_licensees' => 'required|max:255'
        ]);

        if ($validator->fails()) {
            return response(['error' => $validator->errors(), 'Validation Error']);
        }

        $licensee = Licensee::create($data);

        return response(['licensee' => new LicenseeResource($licensee), 'message' => Created successfully], 201);
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Licensee  $licensee
     * @return \Illuminate\Http\Response
     */
    public function show(Licensee $licensee)
    {
        return response(['licensee' => new ProjectResource($licensee), 'message' => 'Retrieved successfully'], 200);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Licensee  $licensee
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Licensee $licensee)
    {
        $licensee->update($request->all());

        return response(['licensee' => new ProjectResource($licensee), 'message' => 'Update successfully'], 200);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Licensee  $licensee
     * @return \Illuminate\Http\Response
     */
    public function destroy(Licensee $licensee)
    {
        $licensee->delete();

        return response(['message' => 'Deleted']);

    }
}
