<?php

namespace App\Http\Controllers\API;

use App\Services\NetLicensingService; // I added
use App\Services\GenerateDb; // I added

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\Models\User; // I added it
use Illuminate\Support\Facades\DB; // I added it
use Illuminate\Support\Facades\Auth; // I added it
use Illuminate\Support\Facades\Hash; // I added it

use Image; // I added it
use File; // I added it
use Validator; // I added it

class UserController extends Controller
{

    /**
    * Write code on Method
    *
    * @return response()
    */
    public function editProfileBasic(Request $request)
    {
        // validator
        $validator = Validator::make($request->all(), [
            'name' => 'required',
            'image' => 'file|image|mimes:jpg,bmp,png,gif,jpeg'
        ], [
            'name.required' => 'Name is required',
            'image.file' =>  'Not a file',
            'image.image' =>  'Not an image',
            'image.mimes' =>  'Does not accept this type of mime'
        ]);

        // check validation
        if ($validator->fails()) {
            $response = [
                'success' => false,
                'message' => $validator->messages()
            ];
            return response($response, 404);
        }

        $status_affected = [];
        $user = Auth::user();
        $userid = $user->id;

        // 1 = affected and 0 = not affected
        if ($request->hasFile('image')) {
            $image = $request->file('image');
            $location = storage_path('/users/user_'.$userid.'/');
            if(!File::isDirectory(storage_path('/users/user_'.$userid.'/'))){
                // create all folders
                File::makeDirectory(storage_path('/users/user_'.$userid.'/'), 0755, true, true);
                File::makeDirectory(storage_path('/users/user_'.$userid.'/profile'), 0755, true, true);
                File::makeDirectory(storage_path('/users/user_'.$userid.'/profile/photo'), 0755, true, true);
            }
            // to delete all files into folder "photo"
            File::cleanDirectory(storage_path('/users/user_'.$userid.'/profile/photo'));
            $filename = $image->getClientOriginalName();
            $location = storage_path('/users/user_'.$userid.'/profile/photo/') . $filename;
            Image::make($image)->resize(500, 500)->save($location);
            $affected['photo'] = DB::table('users')
                        ->where('id', $userid)
                        ->update(['photo' => $filename]);
        }

        if(isset($request->name)){
            $affected['name'] = DB::table('users')
                        ->where('id', $userid)
                        ->update(['name' => $request->name]);
        }

        if(isset($request->name_user)){
            $affected['name_user'] = DB::table('users')
                        ->where('id', $userid)
                        ->update(['name_user' => $request->name_user]);
        }

        if(isset($request->company)){
            $affected['company'] = DB::table('users')
                        ->where('id', $userid)
                        ->update(['company' => $request->company]);
        }

        array_push($status_affected, $affected);

        return response(['status_affected' => $status_affected]);
    }

    /**
    * Write code on Method
    *
    * @return response()
    */
    public function editFullName(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'name' => 'required'
        ], [
            'name.required' => 'Name is required',
        ]);

        if ($validator->fails()) {
            $response = [
                'success' => false,
                'message' => $validator->messages()
            ];
            return response($response, 404);
        }

        $status_affected = [];
        $user = Auth::user();
        $userid = $user->id;

        $affected['name'] = DB::table('users')
                    ->where('id', $userid)
                    ->update(['name' => $request->name]);

        if(isset($request->surnames)){
            $affected['surnames'] = DB::table('users')
                        ->where('id', $userid)
                        ->update(['surnames' => $request->surnames]);
        }

        array_push($status_affected, $affected);

        return response(['status_affected' => $status_affected]);
    }

    /**
    * Write code on Method
    *
    * @return response()
    */
    public function confirmIdentity(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'password' => 'required'
        ], [
            'password.required' => 'Password is required',
        ]);

        if ($validator->fails()) {
            $response = [
                'success' => false,
                'message' => $validator->messages()
            ];
            return response($response, 404);
        }

        $user = Auth::user();

        // Hash::check performs the same function as native php password_verify
        $status_check_pwd = Hash::check($request->password, $user->password) ? true : false ;

        return response(['status_check_pwd' => $status_check_pwd]);
    }

    /**
    * Write code on Method
    *
    * @return response()
    */
    public function editEmail(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'email' => 'required|email:rfc,dns'
        ], [
            'email.required' => 'Email is required',
            'email.email' => 'Email not valid'
        ]);

        if ($validator->fails()) {
            $response = [
                'success' => false,
                'message' => $validator->messages()
            ];
            return response($response, 404);
        }

        $user = Auth::user();
        $userid = $user->id;

        $affected = DB::table('users')
                    ->where('id', $userid)
                    ->update(['email' => $request->email]);

        return response(['affected' => $affected]);
    }

    /**
    * Write code on Method
    *
    * @return response()
    */
    public function editMobilePhone(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'mobile_phone' => 'required'
        ], [
            'mobile_phone.required' => 'Mobile phone is required',
        ]);

        if ($validator->fails()) {
            $response = [
                'success' => false,
                'message' => $validator->messages()
            ];
            return response($response, 404);
        }

        $user = Auth::user();
        $userid = $user->id;

        $affected = DB::table('users')
                    ->where('id', $userid)
                    ->update(['mobile_phone' => $request->mobile_phone]);

        return response(['affected' => $affected]);       
    }

    /**
    * Write code on Method
    *
    * @return response()
    */
    public function editSecondaryEmail(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'email_secondary' => 'required|email:rfc,dns'
        ], [
            'email_secondary.required' => 'Email is required',
        ]);

        if ($validator->fails()) {
            $response = [
                'success' => false,
                'message' => $validator->messages()
            ];
            return response($response, 404);
        }

        $user = Auth::user();
        $userid = $user->id;

        $affected = DB::table('users')
                    ->where('id', $userid)
                    ->update(['secondary_email' => $request->email_secondary]);

        return response(['affected' => $affected]);   
    }

    public function changePassword(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'password' => 'required|min:10'
        ], [
            'password.required' => 'Password is required',
        ]);

        if ($validator->fails()) {
            $response = [
                'success' => false,
                'message' => $validator->messages()
            ];
            return response($response, 404);
        }

        $user = Auth::user();
        $userid = $user->id;

        $password = Hash::make($request->password);

        $affected = DB::table('users')
                    ->where('id', $userid)
                    ->update(['password' => $password]);

        $request->user()->token()->revoke(); // logout

        return response(['affected' => $affected]);
    }

    public function usingApplicationsAndThedesktop(Request $request)
    {
        $user = Auth::user();
        $userid = $user->id;

        $affected = DB::table('users')
                    ->where('id', $userid)
                    ->update(['share_information_about_how_I_use_desktop_applications' => $request->shareAppUse]);

        return response(['affected' => $affected]);
    }

    public function deleteAccount(Request $request)
    {
        $user = Auth::user();
        $userid = $user->id;
        $db_ps= $user->db_ps;
        $licensee_number_db = $user->licensee_number;

        // delete user
        User::where('id', $userid)->delete();

        // delete customer license
        $license_manager = new NetLicensingService();
        $license_manager->deleteLicensee($licensee_number_db); // customer and license

        // delete database point sale
        $generateDb = new GenerateDb();
        $generateDb->deleteDatabase($db_ps);
        $request->user()->token()->revoke(); // logout

        // delete file automatization
        $file_hardware = "/home/desarrollo/api-mng-lcs.inovul.com/automatizacion/Esp32Api_$userid.php";

        unlink($file_hardware); // native function php

        // delete profile user folder
        if(File::exists(storage_path('/users/user_'.$userid.'/'))){
            File::deleteDirectory(storage_path('/users/user_'.$userid));
        }

        return response(['deleteAccount' => 'ok']);
    }

    // public function activeSessions(Request $request){
        // return response([$request->user()->token()]);
    // }
    // $data = $request->session()->all();

}
