<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTransactionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('transactions', function (Blueprint $table) {
            // value equal to 0 only when the license is TryAndBuy (trial license)
            $table->string('number_transaction')->nullable(); // number (unique identifier of the transaction)
            $table->boolean('active')->dafault(true); // active (always in true)
            $table->enum('status', ['CANCELLED', 'CLOSED', 'PENDING', 'TRIAL']); // status
            $table->timestamp('dateCreated')->useCurrent(); // dateCreated
            $table->timestamp('dateClosed')->nullable(); // dateClosed (closed transaction)
            $table->string('paymentMethod')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('transactions');
    }
}
