<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CuentasCorporativas extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('pointsale')->create('cuentas_corporativas', function (Blueprint $table){
            $table->id();
            $table->string('nombre', 255);
            $table->string('telefono', 255);
            $table->string('correo', 255);
            $table->string('identificador', 255);
            $table->string('direccion', 255);
            $table->string('forma_de_pago', 255);
            $table->decimal('descuento', 10, 2);
            $table->boolean('inactivo');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('mysql')->dropIfExists('cuentas_corporativas');
    }
}
