<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class ProductosServicio extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('pointsale')->create('productos_servicio', function (Blueprint $table){
            $table->id('ID_PS');
            $table->string('NombreProducto', 30);
            $table->string('Categoria', 30);
            $table->string('Codigo_de_barras', 20)->nullable();
            $table->decimal('PrecioC_sin_impuesto', 10, 2);
            $table->decimal('Costo_expressC_sin_impuesto', 10, 2)->default(0.00);
            $table->decimal('Porcentaje_Utilidad', 10, 2);
            $table->decimal('PrecioV_sin_impuesto', 10, 2);
            $table->string('Imagen', 500)->nullable()->default('../assets/iconos/bascula.svg');
            $table->integer('id_imagen')->nullable();
            $table->decimal('Costo_expressV_sin_impuestos', 11, 2)->default(0.00);
            $table->integer('BanderaIva');
            // Foreign Key Constraints
            // update and delete cascade
            $table->foreign('Categoria')->references('NombreCat')->on('giro_categoria')->onUpdate('cascade')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('mysql')->dropIfExists('productos_servicio');
    }
}
