<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class Promociones extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('pointsale')->create('promociones', function (Blueprint $table){
            $table->id();
            $table->string('nombre', 255);
            $table->string('descuento_por_relacion', 255)->nullable();
            $table->decimal('descuento_por_procentaje', 10, 2)->nullable();
            $table->boolean('excluir_corporativas', 1);
            $table->integer('dia_inicio');
            $table->integer('mes_inicio');
            $table->integer('ano_inicio');
            $table->integer('dia_final');
            $table->integer('mes_final');
            $table->integer('ano_final');
            $table->boolean('todo_el_dia', 1);
            $table->string('hora_inicio', 255);
            $table->string('minutos_inicio', 255);
            $table->string('hora_final', 255);
            $table->string('minutos_final', 255);
            $table->string('dias_oferta', 1000);
            $table->string('productos_que_aplican', 255);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('mysql')->dropIfExists('promociones');
    }
}
