<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\API\AuthController; // I addes it
use App\Http\Controllers\API\LicenseeController; // I addes it
use App\Http\Controllers\API\UserController; // I addes it

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

// Route::middleware('auth:api')->get('user', function (Request $request) {
    // return $request->user();
// });

Route::group([
      'middleware' => 'auth:api'
    ], function() {
        Route::get('logout', [AuthController::class, 'logout']);
        Route::get('user', [AuthController::class, 'user']);
        Route::get('dwnZip', [AuthController::class, 'download']);
        Route::post('editProfileBasic', [UserController::class, 'editProfileBasic']);
        Route::post('editFullName', [UserController::class, 'editFullName']);
        Route::post('confirmIdentity', [UserController::class, 'confirmIdentity']);
        Route::post('editEmail', [UserController::class, 'editEmail']);
        Route::post('editMobilePhone', [UserController::class, 'editMobilePhone']);
        Route::post('editSecondaryEmail', [UserController::class, 'editSecondaryEmail']);
        Route::post('changePassword', [UserController::class, 'changePassword']);
        Route::post('enableTwoFactorAuth', [TwoFactorAuthController::class], 'enableTwoFactorAuth');
        Route::post('shareAppUse', [UserController::class, 'usingApplicationsAndThedesktop']);
        Route::get('deleteAccount', [UserController::class, 'deleteAccount']);
        // test
        Route::get('activeSessions', [UserController::class, 'activeSessions']);
        // activeSessions
    });

// I added it
Route::post('register', [AuthController::class, 'register']);

Route::post('login', [AuthController::class, 'login']);

Route::post('forgetPassword', [AuthController::class, 'submitForgetPasswordForm']);
Route::post('resetPassword', [AuthController::class, 'submitResetPasswordForm']);

// login google
Route::get('auth/google', [AuthController::class, 'redirectToGoogle']);
Route::get('auth/google/callback', [AuthController::class, 'handleGoogleCallback']);

// login facebook
Route::get('auth/facebook', [AuthController::class, 'facebookRedirect']);
Route::get('auth/facebook/callback', [AuthController::class, 'loginWithFacebook']);

// It use pointsale software inovul
Route::post('pwd_vrf', [AuthController::class, 'pwd_vrf']);
Route::post('login_admin_point_sale', [AuthController::class, 'loginAdminPointSale']);
Route::post('accessPersonalPointSale', [AuthController::class, 'accessPersonalPointSale']);

// test verify Email exist
Route::post('verifyEmail', [AuthController::class, 'verifyEmail']);

// test send email Gmail SMTP server
Route::post('send_mail_gmail_smtp', [AuthController::class, 'sendMailGmailSmtp']);

// test verify Email
Route::post('verifyEmail', [AuthController::class, 'verifyEmail']);

// I added it
// Route::apiResource('licensee', LicenseeController::class)->middleware('auth-api');