<?php

namespace App\Http\Controllers\API;

use App\Services\NetLicensingService; // I added it
use App\Services\GenerateDb; // I added

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User; // I added it
use App\Models\pwd_verify_hash; // I added it
use Illuminate\Support\Facades\Hash; // I added it
use App\Mail\SendMail; // I added it
use Illuminate\Support\Facades\Mail; // I added it
use App\Mail\registerGmail; // I added it
use Illuminate\Support\Facades\Auth; // I added it
use Illuminate\Support\Str; // I added it
use Carbon\Carbon; // I added it
use App\Mail\forgetPassword; // I added it
use Illuminate\Support\Facades\DB; // I added it
use Socialite; // I added it
use Image; // I added it (edit profile basic)
use File; // I added it (edit profile basic)
use Validator; // I added it (edit profile basic)
use Lcobucci\JWT\Parser; // I added it

use SMTPValidateEmail\Validator as SmtpEmailValidator; // I added it


class AuthController extends Controller
{
    public function register(Request $request)
    {
        $validatedData = $request->validate([
            'name' => 'required|string|max:255',
            'surnames' => 'required|string|max:255',
            'email' => 'required|email',
            'password' => 'required|min:10',
            'date_of_birthday' => 'required|date',
            'country_or_region' => 'required|string|max:200',
        ]);
        
        $nameuser = $request->name;
        $surnames = $request->surnames;
        $email = $request->email;

        $details = [
            'nameuser' => $nameuser,
            'surnames' => $surnames,
            'email' => $email
        ];
        Mail::to($email)->send(new registerGmail($details));

        $validatedData['password'] = Hash::make($request->password);

        $user = User::create($validatedData);

        $accessToken = $user->createToken('authToken')->accessToken;

        $license_manager = new NetLicensingService();
        $create_licensee = $license_manager->createLicensee();

        $generateDb = new GenerateDb();
        $tk_db = $generateDb->generateToken();
        $tk_db = "desarrollo_inovul_" .$tk_db; // always to add suffix desarrollo_
        $type = "password";
        $tk_pwd_db = $generateDb->generateToken();
        $db_user = "desarrollo_afodemy";
        $db_user_pwd = "![id9K~^2}j&";
        $generateDb->createDatabase($tk_db, $db_user_pwd, $db_user);
        $generateDb->createTables($tk_db, $db_user, $db_user_pwd);
        $generateDb->seedersPointSale($tk_db);
        $generateDb->createFilePhpHardware($user->id, $tk_db);

        $lcsnum = $create_licensee[0][0];
        // hash db - field
        $generateDb->shareDataClientToPointSale($user->id, $tk_db, $user->email, $lcsnum);

        // It only remains to save the transaction record with an id of 0
        // and keep record of the license that was generated

        // $license = $license_manager->getLicense($lcsnum);
        // $license_number = $license[0];

        // $generateDb->saveTransactionLicenseTrial($user->id);
        // $generateDb->saveLicenseTrialDb($user->id, $license_number);

        // download file zip
        // $zip_file = 'inovul.zip';
        // $zip = new \ZipArchive();
        // $zip->open($zip_file, \ZipArchive::CREATE | \ZipArchive::OVERWRITE);

        // $path = storage_path('dist');
        // $files = new \RecursiveIteratorIterator(new \RecursiveDirectoryIterator($path));
        // foreach ($files as $name => $file)
        // {
            // We're skipping all subfolders
            // if (!$file->isDir()) {
                // $filePath = $file->getRealPath();

                // extracting filename with substr/strlen
                // $relativePath = 'inovul/' . substr($filePath, strlen($path) + 1);

                // $zip->addFile($filePath, $relativePath);
            // }
        // }
        // $zip->close();
        // return (response()->download($zip_file));

        return response(['user' => $user, 'access_token' => $accessToken, 'createLicensee' => $create_licensee], 201);
        // It only remains to save the transaction record with an id of 0
        // and keep record of the license that was generated
    }

    public function login(Request $request)
    {
        $loginData = $request->validate([
            'email' => 'email|required',
            'password' => 'required'
        ]);

        if (!auth()->attempt($loginData)) {
            return response(['message' => 'This User does not exist, check your details'], 400);
        }

        // $accessToken = auth()->user()->createToken('authToken')->accessToken;

        $tokenResult = auth()->user()->createToken('authToken');
        $token = $tokenResult->token;
        $token->save(); // return all fields table oauth_access_tokens

        $accessToken = $tokenResult->accessToken;

        DB::table('sessions_users')->insert([
            'id_token' => $token->id,  // token (format in BD)
            'ip_address' => $request->ip_address,
            'name_browser' => $request->name_browser,
            'name_device' => $request->name_device,
            'latitude' => $request->latitude,
            'longitude' => $request->longitude,
            'last_activity' => now()
        ]);

        return response(['user' => auth()->user(), 'access_token' => $accessToken]);
    }

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function redirectToGoogle()
    {
        return Socialite::driver('google')->stateless()->redirect();
    }

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function handleGoogleCallback() // login with account Google
    {
        try {
    
            $user = Socialite::driver('google')->stateless()->user();
            $finduser = User::where('google_id', $user->id)->first();
     
            if($finduser){
                $accessToken = $finduser->createToken('authToken')->accessToken;
                return redirect('https://cuenta.inovul.com/dashboard?tk='.$accessToken);
            }else{
                $newUser = User::create([
                    'name' => $user->name,
                    'surnames' => "",
                    'email' => $user->email,
                    'google_id' => $user->id,
                    'password' => Hash::make('123456dummy')
                ]);

                $accessToken = $newUser->createToken('authToken')->accessToken;

                $details = [
                    'nameuser' => $newUser->name,
                    'surnames' => $newUser->surnames,
                    'email' => $newUser->email
                ];
                Mail::to($newUser->email)->send(new registerGmail($details));
                $license_manager = new NetLicensingService();
                $create_licensee = $license_manager->createLicensee();
                $generateDb = new GenerateDb();
                $tk_db = $generateDb->generateToken();
                $tk_db = "desarrollo_inovul_" .$tk_db; // always to add suffix desarrollo_
                $type = "password";
                $tk_pwd_db = $generateDb->generateToken();
                $db_user = "desarrollo_afodemy";
                $db_user_pwd = "![id9K~^2}j&";
                $generateDb->createDatabase($tk_db, $db_user_pwd, $db_user);
                $generateDb->createTables($tk_db, $db_user, $db_user_pwd);
                $generateDb->seedersPointSale($tk_db);
                $generateDb->createFilePhpHardware($newUser->id, $tk_db);
                $lcsnum = $create_licensee[0][0];
                $generateDb->shareDataClientToPointSale($newUser->id, $tk_db, $newUser->email, $lcsnum);

                return redirect('https://cuenta.inovul.com/dashboard?tk='.$accessToken);
            }
        } catch (Exception $e) {
            dd($e->getMessage());
        }
    }

    public function facebookRedirect()
    {
        return Socialite::driver('facebook')->stateless()->redirect();
    }

    public function loginWithFacebook()
    {
        try {
    
            $user = Socialite::driver('facebook')->stateless()->user();
            $isUser = User::where('fb_id', $user->id)->first();

            if($isUser){
                $accessToken = $isUser->createToken('authToken')->accessToken;
                return redirect('https://cuenta.inovul.com/dashboard?tk='.$accessToken);
            }else{
                $createUser = User::create([
                    'name' => $user->name,
                    'surnames' => "",
                    'email' => $user->email,
                    'fb_id' => $user->id,
                    'password' => Hash::make('admin@123')
                ]);
    
                $details = [
                    'nameuser' => $createUser->name,
                    'surnames' => $createUser->surnames,
                    'email' => $createUser->email
                ];
                Mail::to($createUser->email)->send(new registerGmail($details));
                $license_manager = new NetLicensingService();
                $create_licensee = $license_manager->createLicensee();
                $generateDb = new GenerateDb();
                $tk_db = $generateDb->generateToken();
                $tk_db = "desarrollo_inovul_" .$tk_db; // always to add suffix desarrollo_
                $type = "password";
                $tk_pwd_db = $generateDb->generateToken();
                $db_user = "desarrollo_afodemy";
                $db_user_pwd = "![id9K~^2}j&";
                $generateDb->createDatabase($tk_db, $db_user_pwd, $db_user);
                $generateDb->createTables($tk_db, $db_user, $db_user_pwd);
                $generateDb->seedersPointSale($tk_db);
                $generateDb->createFilePhpHardware($createUser->id, $tk_db);
                $lcsnum = $create_licensee[0][0];
                $generateDb->shareDataClientToPointSale($createUser->id, $tk_db, $createUser->email, $lcsnum);
    
                $accessToken = $createUser->createToken('authToken')->accessToken;
                return redirect('https://cuenta.inovul.com/dashboard?tk='.$accessToken);
            }
    
        } catch (Exception $exception) {
            dd($exception->getMessage());
        }
    }

    public function logout(Request $request)
    {
        $request->user()->token()->revoke();

        return response()->json([
            'message' => 'Successsfully logged out'
        ]);
    }

    /**
    * Write code on Method
    *
    * @return response()
    */
    public function submitForgetPasswordForm(Request $request)
    {
        $request->validate([
          'email' => 'required|email|exists:users',
        ]);

        $token = Str::random(64);

        DB::table('password_resets')->insert([
          'email' => $request->email, 
          'token' => $token, 
          'created_at' => Carbon::now()
        ]);

        $email = $request->email;

        $details = [
            'token' => $token,
            'email' => $email
        ];
        Mail::to($email)->send(new forgetPassword($details));

        return response()->json(['message' => 'We have e-mailed your password reset link!']);

        // return back()->with('message', 'We have e-mailed your password reset link!');
    }

      /**
       * Write code on Method
       *
       * @return response()
       */
    public function submitResetPasswordForm(Request $request)
    {
        $request->validate([
          'email' => 'required|email|exists:users',
          'password' => 'required|string|min:10',
          'confirmPassword' => 'required|same:password'
        ]);

        $updatePassword = DB::table('password_resets')
                          ->where([
                            'email' => $request->email, 
                            'token' => $request->token
                          ])
                          ->first();

        if(!$updatePassword){
            return response()->json(['no_token' => 'Invalid token!']);
        }

        $user = User::where('email', $request->email)
                  ->update(['password' => Hash::make($request->password)]);

        DB::table('password_resets')->where(['email'=> $request->email])->delete();
        return response()->json(['message' => 'Your password has been changed!']);
    }


    public function user(Request $request)
    {

        $bearerToken = $request->bearerToken();
        $id = (new Parser())->parse($bearerToken)->getClaim('jti');
        $tokenDb = $request->user()->tokens->find($id);

        $user = Auth::user();
        $user['id_tk_db'] = $tokenDb;

        return response()->json($user);

        // return response()->json(Auth::user());
    }

    // download file installer
    public function download(Request $request)
    {
        $path = storage_path('dist/inovul_setup.exe');
        return response()->download($path);
    }


    // point sale
    public function pwd_vrf(Request $request){ // login main software point of sale
        $dataPwdVerify = $request->validate([
            'email' => 'required',
            'password' => 'required'
        ]);

        $email = $request->email;
        $user = User::whereEmail($request->email)->first();

        $pwdvrf = password_verify($request->password, $user->password) ? true : false;
        if ($pwdvrf == true) return response(['db_ps' => $user->db_ps , 'pwdvrf' => $pwdvrf]);
        return response(['pwdvrf' => $pwdvrf]);
    }
    
    

    // point sale
    public function loginAdminPointSale(Request $request){
        $dataPwdVerifyPointSale = $request->validate([
            'dbname' => 'required',
            'password' => 'required'
        ]);
        $dbaname= $request->dbname;
        $password = $request->password;
        $generateDb = new GenerateDb();
        $pwdAdmin = $generateDb->loginPointSaleAdmin($dbaname, $password);
        $pwdvrfAdminPointSale = password_verify($password, $pwdAdmin) ? true : false;
        return response(['pwd_vrf_adm_pntsl' => $pwdvrfAdminPointSale]);
    }

    // point sale
    public function accessPersonalPointSale(Request $request){
        $dataAccessPersonalPointSale = $request->validate([
            'dbname' => 'required',
            'password' => 'required'
        ]);
        $dbaname= $request->dbname;
        $password = $request->password;

        $generateDb = new GenerateDb();
        $dataAccessPersonal = $generateDb->loginAccessPersonalPointSale($dbaname, $password);
        $pwdDb = $dataAccessPersonal->contrasena;
        if(password_verify($password, $pwdDb)){
            return response(['dataAccessPersonal' => $dataAccessPersonal, 'access' => true]);
        }else{
            return response(['access' => false]);
        }
    }

    // test to send email with server smtp Gmail
    public function sendMailGmailSmtp(Request $request)
    {
        $nameuser = $request->nameuser;
        $surnames = $request->surnames;
        $email = $request->email;

        $details = [
            'nameuser' => $nameuser,
            'surnames' => $surnames,
            'email' => $email
        ];
        Mail::to($email)->send(new registerGmail($details));

        return response(['details' => $details]);
    }

    // test verify Email exist
    public function verifyEmail(Request $request){
        $email = $request->email;

        $emails    = [
            $email
        ];

        $sender    = 'sender@example.org';
        $validator = new SmtpEmailValidator($emails, $sender);
        $results   = $validator->validate();
        return response(['resultVerifyEmail' => $results]);
    }

}
