<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class ClientesRegistrados extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('pointsale')->create('clientes_registrados', function (Blueprint $table){
            $table->id('ID_Cliente');
            $table->string('NombreCliente', 50);
            $table->string('ApellidoPCliente', 20);
            $table->string('ApellidoMCliente', 20);
            $table->string('NombredeBusqueda', 50);
            $table->string('NumerodeTarjeta', 50);
            $table->integer('Saldo')->default('0');
            $table->string('Telefono', 13);
            $table->string('Correo', 50);
            $table->string('Direccion', 50);
            $table->date('Cumpleanos');
            $table->boolean('RutaRecoleccion');
            $table->boolean('inactivo');
            $table->decimal('Descuento', 10, 1);
            $table->date('fecha_registro')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('mysql')->dropIfExists('clientes_registrados');
    }
}
