<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class RegistroPsTicket extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('pointsale')->create('registro_ps_ticket', function (Blueprint $table){
            $table->id('ID_RT');
            $table->string('NombreProducto', 100);
            $table->string('Color', 20);
            $table->string('Fibra', 20);
            $table->integer('Cantidad');
            $table->decimal('PrecioV_sin_impuesto', 10, 1);
            $table->string('NombreExtra', 200);
            $table->decimal('PrecioExtra', 10, 1);
            $table->decimal('Descuento', 10, 1);
            $table->decimal('Importe', 10, 1);
            $table->string('Categoria', 100);
            $table->string('IdentificadorCB', 30);
            $table->integer('ID_Ticket');
            $table->string('Estado', 20);
            $table->string('equipo_asignado', 20);
            $table->string('EstadodePago', 20);
            $table->integer('id_corte_turno')->nullable();
            $table->integer('id_corte_dia')->nullable();
            $table->integer('id_corte_mes')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('mysql')->dropIfExists('registro_ps_ticket');
    }
}
