<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class Tickets extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('pointsale')->create('tickets', function (Blueprint $table){
            $table->id('ID_Ticket');
            $table->date('Fecha_de_recepcion');
            $table->time('Hora_registrada');
            $table->date('Fecha_de_entrega');
            $table->time('Hora_de_entrega');
            $table->string('NombreCliente', 255);
            $table->integer('id_cliente')->nullable();
            $table->integer('id_cuenta_corporativa')->nullable();
            $table->string('creadopor', 20);
            $table->string('Estado', 20);
            $table->decimal('Efectivo', 10, 2);
            $table->decimal('Tarjeta', 10, 2);
            $table->decimal('SubTotal', 10, 2);
            $table->decimal('anticipo', 10, 2);
            $table->decimal('porpagar', 10, 2);
            $table->decimal('impuesto', 10, 2);
            $table->decimal('Totalapagar', 10, 2);
            $table->decimal('Cambio', 10, 2);
            $table->decimal('CantidadRecibida', 10, 2);
            $table->integer('id_corte_turno')->nullable();
            $table->integer('id_corte_dia')->nullable();
            $table->integer('id_corte_mes')->nullable();
            $table->string('Telefono', 13);
            $table->text('Motivo');
            $table->decimal('Descuento', 10, 2);
            $table->string('Digitos_Tarjeta', 5);
            $table->string('promocion_aplicada', 50);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('mysql')->dropIfExists('tickets');
    }
}
