<?php 
    /**
     * 
     * library for to create database with cpanel 
     * https://github.com/N1ghteyes/cpanel-UAPI-php-class
     * example in 
     * https://github.com/N1ghteyes/cpanel-UAPI-php-class/blob/master/examples/mysql.php
     **/

    namespace App\Services;
    // library for API Cpanel
    use App\Services\library\cpanelUAPIphpclassmaster\cpanelAPI;
    use Illuminate\Support\Facades\Config;
    use Illuminate\Support\Facades\DB;
    use Illuminate\Support\Facades\Artisan;

    class GenerateDb{
        // attributes (known as variable out of a class)
        private $cPanel;
        public function __construct()

        {
        }

        public function generateToken($type = "") // Unique token for the database and password database
        {
            //Generate a random string with openssl
            $token = openssl_random_pseudo_bytes(16);
            //Convert the binary data into hexadecimal representation.
            $token = bin2hex($token);

            if($type == "password") $token = password_hash(bin2hex($token), PASSWORD_DEFAULT);

            return $token;
        }

        public function createDatabase($database, $databasepass, $databaseuser)
        {
            $this->cPanel = new cpanelAPI('desarrollo', 'sHX%=MAmb-m@', 'afodemy.com');
            // Create the database
            $act_create_db = $this->cPanel->uapi->Mysql->create_database(array('name' => $database));
            // create a user for the new database
            $this->cPanel->uapi->Mysql->create_user(array('name' => $databaseuser, 'password' => $databasepass));
            // add the user, set all privileges - add specific privileges by comma separation. e.g. 'DELETE,UPDATE,CREATE,ALTER'
            $this->cPanel->uapi->Mysql->set_privileges_on_database(array('user' => $databaseuser, 'database' => $database, 'privileges' => 'ALL'));
            return $this->cPanel;
        }

        public function deleteDatabase($database)
        {
            $this->cPanel = new cpanelAPI('desarrollo', 'sHX%=MAmb-m@', 'afodemy.com');
            // Delete database
            $this->cPanel->uapi->Mysql->delete_database(array('name' => $database));
        }

        public function createTables($dbname, $user, $password)
        {

            //new database name, you want to connect to.
            Config::set('database.connections.pointsale.database', $dbname); 
            DB::connection('pointsale');
            Artisan::call('migrate', array('--path' => 'database/migrationspointsale', '--force' => true));
            DB::disconnect('pointsale');
            DB::connection('mysql');
            Artisan::call('migrate:rollback', array('--path' => 'database/migrationspointsale', '--force' => true));
        }

        public function seedersPointSale($dbname){
            Config::set('database.connections.pointsale.database', $dbname); 
            DB::connection('pointsale');
            Artisan::call('db:seed', array('--class' => 'color', '--force' => true));
            Artisan::call('db:seed', array('--class' => 'documentos', '--force' => true));
            Artisan::call('db:seed', array('--class' => 'fibras', '--force' => true));
            Artisan::call('db:seed', array('--class' => 'motivos_de_cancelacion', '--force' => true));
            Artisan::call('db:seed', array('--class' => 'giro_categoria', '--force' => true));
            Artisan::call('db:seed', array('--class' => 'costo_equipos', '--force' => true));
            DB::disconnect('pointsale');
        }

        public function createFilePhpHardware($client_id, $dbname)
        {
            // route absolute
            // C:\Users\SmartTec\Documents
            $file_to_generate = fopen("/home/desarrollo/api-mng-lcs.inovul.com/automatizacion/Esp32Api_$client_id.php", "w") or die("Unable to open file!");
            $file_php = "/home/desarrollo/api-mng-lcs.inovul.com/automatizacion/Esp32Api.php";
            $txt = file_get_contents($file_php);
            $patron = '/basededatos = "Inovul";/';
            $sustitucion = "basededatos = \"$dbname\";";
            $txt = preg_replace($patron, $sustitucion, $txt);
            fwrite($file_to_generate, $txt);
            fclose($file_to_generate);
        }

        public function shareDataClientToPointSale($id_u, $dbname, $correo, $lcsnum)
        {
            $data_users = DB::table('users')->select('password')->where('id', $id_u)->get();
            DB::disconnect('mysql');
            // Config::set('database.connections.pointsale.database', $dbname);
            DB::connection('pointsale');
            // dd($pwd);
            // query insert
            $permisos = '["crear_ticket","cancelar_ticket","agregar_producto","agregar_extras","corte_de_caja","autorizacion_descuentos","visualizacion_de_reportes","todas_las_funciones_de_crear","editar","visualizar","eliminar"]';
            DB::connection('pointsale')->table('administradores')->insert([
                'lcsnum' => $lcsnum,
                'pointsale_db' => $dbname,
                'Correo' => $correo, 
                'contrasena' => $data_users[0]->password,
                'Nombre' => "",
                'Telefono' => "",
                'Rol' => "administrador",
                'permisos' => $permisos
            ]);

            // password default cipher with md5 (sp => soporte tecnico)
            $pwd_default_sp = '17-02-2021';
            $permisos_sp = '["Configurar Equipos"]';

            DB::connection('pointsale')->table('administradores')->insert([
                'Correo' => "", 
                'contrasena' => md5($pwd_default_sp),
                'Nombre' => "Soporte Tecnico",
                'Telefono' => "",
                'Rol' => "Soporte",
                'permisos' => $permisos_sp
            ]);
            // query insert
            DB::disconnect('pointsale');
            DB::connection('mysql');

            $affected = DB::table('users')
                          ->where('id', $id_u)
                          ->update(['licensee_number' => $lcsnum, 'db_ps' => $dbname]);
            return $affected;
        }

        public function saveTransactionLicenseTrial($client_id)
        {
            DB::table('transactions')->insert([
                'number_transaction' => '0_' .$client_id, 
                'status' => 'TRIAL'
            ]);
        }


        public function saveLicenseTrialDb($client_id, $license_number)
        {
            DB::table('licenses')->insert([
                'number_license' => $license_number,
                'number_transaccion' => '0_' .$client_id,
                'type' => 'Try And Buy'
            ]);
        }

        public function loginPointSaleAdmin($dbname, $pwd){
            Config::set('database.connections.pointsale.database', $dbname); 
            $dataAdminPointSale = DB::connection('pointsale')->table('administradores')->select('contrasena')->where('pointsale_db', $dbname)->get();
            $contrasena = $dataAdminPointSale[0]->contrasena;
            DB::disconnect('pointsale');
            return $contrasena;
        }

        public function loginAccessPersonalPointSale($dbname, $pwd){
            Config::set('database.connections.pointsale.database', $dbname); 
            $dataSql = DB::connection('pointsale')->table('administradores')->select(['BanderaInicioSesion','Fecha_de ultima_sesion', 'Hora_Inicio_sesion', 'Hora_de_termino_sesion', 'contrasena', 'permisos'])->where('pointsale_db', $dbname)->get();
            $data = $dataSql[0];
            DB::disconnect('pointsale');
            return $data;
            // ['pointsale_db', $dbname], ['contrasena', $pwd]
        }

    }
    // https://inovul.com/public/api/register
 ?>