<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\API\CleanApp; // I addes it
use App\Http\Controllers\API\AuthController; // I addes it
use App\Http\Controllers\API\LicenseeController; // I addes it
use App\Http\Controllers\API\UserController; // I addes it
use App\Http\Controllers\API\Notification; // I addes it
use App\Http\Controllers\API\PaymentController; // I addes it
use App\Http\Controllers\API\ClientCardPointSaleController; // I addes it

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

// Route::middleware('auth:api')->get('user', function (Request $request) {
    // return $request->user();
// });

Route::group([
      'middleware' => 'auth:api'
    ], function() {
        Route::get('logout', [AuthController::class, 'logout']);
        Route::get('user', [AuthController::class, 'user']);
        Route::get('dwnZip', [AuthController::class, 'download']);
        Route::post('editProfileBasic', [UserController::class, 'editProfileBasic']);
        Route::post('editFullName', [UserController::class, 'editFullName']);
        Route::post('confirmIdentity', [UserController::class, 'confirmIdentity']);
        Route::post('editEmail', [UserController::class, 'editEmail']);
        Route::post('editMobilePhone', [UserController::class, 'editMobilePhone']);
        Route::post('editSecondaryEmail', [UserController::class, 'editSecondaryEmail']);
        Route::post('changePassword', [UserController::class, 'changePassword']);
        Route::post('enableTwoFactorAuth', [TwoFactorAuthController::class], 'enableTwoFactorAuth');
        Route::post('shareAppUse', [UserController::class, 'usingApplicationsAndThedesktop']);
        Route::get('deleteAccount', [UserController::class, 'deleteAccount']);
        Route::post('checkNotificationSms', [Notification::class, 'checkNotificationSms']);
        Route::get('activeSessions', [UserController::class, 'activeSessions']);
        Route::post('deleteSession', [UserController::class, 'deleteSession']);
        Route::post('deleteAllSessions', [UserController::class, 'deleteAllSessions']);
        // createLicensePrincingTable
        Route::post('createLicensePrincingTable', [LicenseeController::class, 'createLicensePrincingTable']);
        // listTemplateLicense
        Route::get('productsModulesAndLicensesTemplates', [LicenseeController::class, 'productsModulesAndLicensesTemplates']);
        // getLinkShopPlan
        Route::post('getLinkShopPlan', [LicenseeController::class, 'getLinkShopPlan']);
        Route::post('checkNotiLatestByEmail', [Notification::class, 'checkNotiLatestByEmail']);
        Route::post('checkNotificationByCellPhone', [Notification::class, 'checkNotificationByCellPhone']);
        Route::post('checkNotificationInstructionalEmails', [Notification::class, 'checkNotificationInstructionalEmails']);
        // test checkout with paypal (sandbox default)
        Route::post('/paypal/pay', [PaymentController::class, 'payWithPayPal']);
    });

// I added it
Route::post('register', [AuthController::class, 'register']);

Route::post('login', [AuthController::class, 'login']);

Route::post('forgetPassword', [AuthController::class, 'submitForgetPasswordForm']);
Route::post('resetPassword', [AuthController::class, 'submitResetPasswordForm']);

// login google
Route::get('auth/google', [AuthController::class, 'redirectToGoogle']);
Route::get('auth/google/callback', [AuthController::class, 'handleGoogleCallback']);

// login facebook
Route::get('auth/facebook', [AuthController::class, 'facebookRedirect']);
Route::get('auth/facebook/callback', [AuthController::class, 'loginWithFacebook']);

// It use pointsale software inovul
Route::post('pwd_vrf', [AuthController::class, 'pwd_vrf']);
Route::post('login_admin_point_sale', [AuthController::class, 'loginAdminPointSale']);
Route::post('accessPersonalPointSale', [AuthController::class, 'accessPersonalPointSale']);
// Client Card
Route::post('searchClient', [ClientCardPointSaleController::class, 'searchClient']);
Route::post('updateNumberCardAndBalance', [ClientCardPointSaleController::class, 'updateNumberCardAndBalance']);
Route::post('rechargeCard', [ClientCardPointSaleController::class, 'rechargeCard']);


// test verify Email exist
Route::post('verifyEmail', [AuthController::class, 'verifyEmail']);

// test send email Gmail SMTP server
Route::post('send_mail_gmail_smtp', [AuthController::class, 'sendMailGmailSmtp']);

// test verify Email
Route::post('verifyEmail', [AuthController::class, 'verifyEmail']);

// clean app
Route::post('cleanGral', [CleanApp::class, 'cleanGral']);

// test
Route::post('createOnlyClientNtl', [LicenseeController::class, 'createOnlyClientNtl']);

Route::get('/paypal/status', [PaymentController::class, 'payPalStatus']);